;;; Test file for Lisp mode syntax highlighting
;;; Tests various Lisp/Scheme constructs

;; Basic function definition
(defun factorial (n)
  "Calculate factorial of n"
  (if (<= n 1)
      1
      (* n (factorial (- n 1)))))

;; Lambda expressions
(mapcar (lambda (x) (* x x)) '(1 2 3 4 5))

;; Special forms
(let ((x 10)
      (y 20))
  (+ x y))

(let* ((x 10)
       (y (+ x 5)))
  (* x y))

;; Scheme-style define
(define (square x)
  (* x x))

;; Quoted symbols and lists
'(a b c)
`(a ,b c)
'|symbol with spaces|

;; Reader macros
#\a          ; character constant
#\space      ; character constant
#\\          ; backslash character
#(1 2 3)     ; vector literal

;; Common Lisp reader macros
#b1010       ; binary
#o755        ; octal
#xff         ; hexadecimal
#'function   ; function quote
#.form       ; read-time eval
#+feature    ; feature conditional
#-feature    ; feature conditional

;; Scheme booleans
#t #f #T #F

;; Multi-line comment (Common Lisp)
#|
This is a multi-line comment
that spans several lines.
|#

;; Nested parentheses
(defun deeply-nested (x)
  (+ (+ (+ (+ x 1) 2) 3) 4))

;; String with escapes
"Hello, \"World\"!"
"Line 1
Line 2"

;; Edge case: # at end of line
(print "hash") #
